# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdusage import *
from .sdvalue import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueUsage(SDValue):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueUsage
        """
        super(SDValueUsage, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(sdUsage : SDUsage) -> Optional[SDValueUsage]:
        """
        Create a new SDValueUsage from a SDUsage

        :param sdUsage: The SDUsage value to set
        """
        outSDValueUsage = ctypes.c_void_p()
        _res = sd.getContext().SDValueUsage_sNew(sdUsage.mHandle, ctypes.byref(outSDValueUsage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueUsage, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueUsage.value, ownHandle=True)

    def get(self) -> Optional[SDUsage]:
        """
        Get the value as SDUsage

        """
        outSDUsage = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueUsage_get(self.mHandle, ctypes.byref(outSDUsage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDUsage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDUsage.value, ownHandle=True)

